<?php defined('SYSPATH') or die('No direct script access.');

class Task_Indexer_Optimize_History extends Minion_Task {

    protected function _execute(array $params){
        $indexes = $this->scanDir('/home/new_sphinx/');

        foreach($indexes as $i){
            $info = $this->getConfigByDB($i);

            foreach($info as $c){
                $c = $this->updPath($c);
                $db_limit = DB::select('id')
                    ->from('counter')
                    ->where('name', '=', $c['name'])
                    ->limit(1)
                    ->execute()
                    ->as_array(null, 'id');

                if(count($this->scanDir($c['path'])) > 12 && intval($db_limit[0]) == $c['limit']){
                    $db_conf = Kohana::$config->load('database');
                    $port = $db_conf[$c['database']]['connection']['port'];

                    /* FLUSH RAM chunk */
                    exec('mysql -e "FLUSH RAMCHUNK '.$c['name'].'" -h127.0.0.1 -P'.$port);

                    /* OPTIMIZE */
                    exec('mysql -e "OPTIMIZE INDEX '.$c['name'].'" -h127.0.0.1 -P'.$port);

                    do{
                        sleep(5);
                    }while(count($this->scanDir($c['path'])) > 13);
                }else{
                    sleep(3);
                }
            }
        }
    }

    private function scanDir($path){
        $trash = ['bin', 'pid', '.', '..'];
        $files = scandir($path);
        foreach($trash as $t){
            unset($files[array_search($t, $files)]);
        }
        return $files;
    }

    private function updPath($params){
        preg_match('#sphinx\_(\d{1,3}\_\d+)#', $params['database'], $path_part_1);
        preg_match('#\d?(\d{1,2})\_\d+#', $params['name'], $tmp_path_part_2);
        $path_part_2 = intval($tmp_path_part_2[1]);
        $params['path'] = '/home/new_sphinx/'.$path_part_1[1].'/'.$path_part_2;
        return $params;
    }

    public static function getConfigByDB($db){
        $array = array();
        $config = Kohana::$config->load('config_history')->as_array();
        foreach($config as $k => $c){
            foreach($c as $n => $limit){
                if(substr($k, 7) == $db){
                    $array[] = [
                        'limit' => $limit,
                        'database' => $k,
                        'name' => $n
                    ];
                }
            }
        }
        return $array;
    }
}